//---------------------------------------------------------------------------------------------
// Torque Game Builder
// Copyright (C) GarageGames.com, Inc.
//---------------------------------------------------------------------------------------------

$Gui::fontCacheDirectory = getPrefsPath("fonts");
//$Gui::fontCacheDirectory = expandFilename("./font");
echo("#################  font cache ################ ", $Gui::fontCacheDirectory);


//####################################################################################
//##############        ADDED FROM GuiResolution TUTORIAL     ########################
//####################################################################################

//%fontRes = GetWords($pref::Video::resolution,0,0);
%fontRes = GetWords($Game::Resolution,0,0);


if (%fontRes == 1680)      { $fontbase = 4; }
else if (%fontRes == 1440) { $fontbase = 4; }
else if (%fontRes == 1280) { $fontbase = 3; }
else if (%fontRes == 1024) { $fontbase = 3; }  //default resolution
else if (%fontRes == 800)  { $fontbase = 2; }
else if (%fontRes == 720)  { $fontbase = 2; }
else if (%fontRes == 640)  { $fontbase = 2; }

$font0 = $fontbase * 8 *0.9;  //=24/3
$font05 = $fontbase * 10 *0.9;  //=30/3
$font1 = $fontbase * 12 *0.9;  //=36/3
$font2 = $fontbase * 18 *0.9;  //=56/3 
$font3 = $fontbase * 24 *0.9;  //=72/3 

//####################################################################################
//##############        END ADDED FROM GuiResolution TUTORIAL     ########################
//####################################################################################
//---------------------------------------------------------------------------------------------
// GuiDefaultProfile is a special profile that all other profiles inherit defaults from. It
// must exist.
//---------------------------------------------------------------------------------------------
if(!isObject(GuiDefaultProfile)) new GuiControlProfile (GuiDefaultProfile)
{
   tab = false;
   canKeyFocus = false;
   hasBitmapArray = false;
   mouseOverSelected = false;

   // fill color
   opaque = false;
   fillColor = "211 211 211";
   fillColorHL = "244 244 244";
   fillColorNA = "244 244 244";

   // border color
   border = 0;
   borderColor   = "40 40 40 100";
   borderColorHL = "128 128 128";
   borderColorNA = "64 64 64";

   // font
   fontType = "Arial";
   fontSize = 14;

   fontColor = "0 0 0";
   fontColorHL = "32 100 100";
   fontColorNA = "0 0 0";
   fontColorSEL= "200 200 200";

   // bitmap information
   bitmap = "./images/window";
   bitmapBase = "";
   textOffset = "0 0";

   // used by guiTextControl
   modal = true;
   justify = "left";
   autoSizeWidth = false;
   autoSizeHeight = false;
   returnTab = false;
   numbersOnly = false;
   cursorColor = "0 0 0 255";

   // sounds
   soundButtonDown = "";
   soundButtonOver = "";
};

if(!isObject(GuiSolidDefaultProfile)) new GuiControlProfile (GuiSolidDefaultProfile)
{
   opaque = true;
   border = true;
};

if(!isObject(GuiTransparentProfile)) new GuiControlProfile (GuiTransparentProfile)
{
   opaque = false;
   border = false;
};


if(!isObject(GuiToolTipProfile)) new GuiControlProfile (GuiToolTipProfile)
{
   // fill color
   fillColor = "239 237 222";

   // border color
   borderColor   = "138 134 122";

   // font
   fontType = "Arial";
   fontSize = 14;
   fontColor = "0 0 0";

};

if(!isObject(GuiModelessDialogProfile)) new GuiControlProfile("GuiModelessDialogProfile")
{
   modal = false;
};

if(!isObject(GuiFrameSetProfile)) new GuiControlProfile (GuiFrameSetProfile)
{
   fillColor = "239 237 222";
   borderColor   = "138 134 122";
   opaque = true;
   border = true;
};


if(!isObject(GuiWindowProfile)) new GuiControlProfile (GuiWindowProfile)
{
   opaque = true;
   border = 1;
   fillColor = "211 211 211";
   fillColorHL = "190 255 255";
   fillColorNA = "255 255 255";
   fontColor = "0 0 0";
   fontColorHL = "200 200 200";
   text = "untitled";
   bitmap = "./images/window";
   textOffset = "5 5";
   hasBitmapArray = true;
   justify = "center";
};

if(!isObject(GuiContentProfile)) new GuiControlProfile (GuiContentProfile)
{
   opaque = true;
   fillColor = "255 255 255";
};

if(!isObject(GuiBlackContentProfile)) new GuiControlProfile (GuiBlackContentProfile)
{
   opaque = true;
   fillColor = "0 0 0";
};

if(!isObject(GuiInputCtrlProfile)) new GuiControlProfile( GuiInputCtrlProfile )
{
   tab = true;
   canKeyFocus = true;
};

if(!isObject(GuiTextProfile)) new GuiControlProfile (GuiTextProfile)
{
   fontColor = "0 0 0";
};

if(!isObject(GuiMediumTextProfile)) new GuiControlProfile (GuiMediumTextProfile : GuiTextProfile)
{
   fontSize = 24;
};

if(!isObject(GuiBigTextProfile)) new GuiControlProfile (GuiBigTextProfile : GuiTextProfile)
{
   fontSize = 36;
};

if(!isObject(GuiMLTextProfile)) new GuiControlProfile ("GuiMLTextProfile")
{
   fontColorLink = "255 96 96";
   fontColorLinkHL = "0 0 255";
   autoSizeWidth = true;
   autoSizeHeight = true;  
   border = false;
};

if(!isObject(GuiTextArrayProfile)) new GuiControlProfile (GuiTextArrayProfile : GuiTextProfile)
{
   fontColorHL = "32 100 100";
   fillColorHL = "200 200 200";
};

if(!isObject(GuiTextListProfile)) new GuiControlProfile (GuiTextListProfile : GuiTextProfile) 
{
   tab = true;
   canKeyFocus = true;
};

if(!isObject(GuiTextEditProfile)) new GuiControlProfile (GuiTextEditProfile)
{
   opaque = true;
   fillColor = "255 255 255";
   fillColorHL = "128 128 128";
   border = -2;
   bitmap = "./images/textEdit";
   borderColor = "40 40 40 100";
   fontColor = "0 0 0";
   fontColorHL = "255 255 255";
   fontColorNA = "128 128 128";
   textOffset = "4 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
   
};

if(!isObject(GuiProgressProfile)) new GuiControlProfile ("GuiProgressProfile")
{
   opaque = false;
   fillColor = "44 152 162 100";
   border = true;
   borderColor   = "78 88 120";
};

if(!isObject(GuiProgressTextProfile)) new GuiControlProfile ("GuiProgressTextProfile")
{
   fontColor = "0 0 0";
   justify = "center";
};

if(!isObject(GuiButtonProfile)) new GuiControlProfile (GuiButtonProfile)
{
   opaque = true;
   border = -1;
   fontColor = "0 0 0";
   fontColorHL = "32 100 100";
   fixedExtent = true;
   justify = "center";
   canKeyFocus = false;
   bitmap = "./images/button";
};

if(!isObject(GuiCheckBoxProfile)) new GuiControlProfile (GuiCheckBoxProfile)
{
   opaque = false;
   fillColor = "232 232 232";
   border = false;
   borderColor = "0 0 0";
   fontSize = 14;
   fontColor = "0 0 0";
   fontColorHL = "32 100 100";
   fixedExtent = true;
   justify = "left";
   bitmap = "./images/checkBox";
   hasBitmapArray = true;
};

if(!isObject(GuiRadioProfile)) new GuiControlProfile (GuiRadioProfile)
{
   fontSize = 14;
   fillColor = "232 232 232";
   fontColorHL = "32 100 100";
   fixedExtent = true;
   bitmap = "./images/radioButton";
   hasBitmapArray = true;
};

if(!isObject(GuiScrollProfile)) new GuiControlProfile (GuiScrollProfile)
{
   opaque = true;
   fillColor = "255 255 255";
   border = 1;
   borderThickness = 2;
   bitmap = "./images/scrollBar";
   hasBitmapArray = true;
};

if(!isObject(GuiTransparentScrollProfile)) new GuiControlProfile (GuiTransparentScrollProfile)
{
   opaque = false;
   fillColor = "255 255 255";
   border = false;
   borderThickness = 2;
   borderColor = "0 0 0";
   bitmap = "./images/scrollBar";
   hasBitmapArray = true;
};
 
if(!isObject(GuiSliderProfile)) new GuiControlProfile (GuiSliderProfile)
{
   bitmap = "./images/slider";
};

if(!isObject(GuiPaneProfile)) new GuiControlProfile(GuiPaneProfile)
{
   bitmap = "./images/popupMenu";
   hasBitmapArray = true;
};



if(!isObject(GuiPopupMenuItemBorder)) new GuiControlProfile ( GuiPopupMenuItemBorder : GuiButtonProfile )
{
   borderColor = "51 51 53 200";
   borderColorHL = "51 51 53 200";

};
if(!isObject(GuiPopUpMenu)) new GuiControlProfile (GuiPopUpMenuDefault : GuiDefaultProfile )
{
   opaque = true;
   mouseOverSelected = true;
   textOffset = "3 3";
   border = 4;
   borderThickness = 2;
   fixedExtent = true;
   bitmap = "./images/scrollBar";
   hasBitmapArray = true;
   profileForChildren = GuiPopupMenuItemBorder;
   fillColor = "255 255 255 200";
   fontColorHL = "128 128 128";
   borderColor = "151 151 153 175";
   borderColorHL = "151 151 153 175";

};


if(!isObject(GuiPopUpMenuProfile)) new GuiControlProfile (GuiPopUpMenuProfile : GuiPopUpMenuDefault)
{
   textOffset         = "6 3";
   bitmap             = "./images/dropDown";
   hasBitmapArray     = true;
   border             = -3;
   profileForChildren = GuiPopUpMenuDefault;
};

if(!isObject(GuiPopUpMenuEditProfile)) new GuiControlProfile (GuiPopUpMenuEditProfile : GuiPopUpMenuDefault)
{
   textOffset         = "6 3";
   canKeyFocus        = true;
   bitmap             = "./images/dropDown";
   hasBitmapArray     = true;
   border             = -3;
   profileForChildren = GuiPopUpMenuDefault;
};

if(!isObject(GuiListBoxProfile)) new GuiControlProfile (GuiListBoxProfile)
{
   tab = true;
   canKeyFocus = true;
};

if(!isObject(GuiTabBookProfile)) new GuiControlProfile (GuiTabBookProfile)
{
   fillColor = "255 255 255";
   fillColorHL = "64 150 150";
   fillColorNA = "150 150 150";
   fontColor = "30 30 30";
   fontColorHL = "32 100 100";
   fontColorNA = "0 0 0";
   fontType = "Arial Bold";
   fontSize = 14;
   justify = "center";
   bitmap = "./images/tab";
   tabWidth = 64;
   tabHeight = 24;
   tabPosition = "Top";
   tabRotation = "Horizontal";
   textOffset = "0 -2";
   tab = true;
   cankeyfocus = true;
};
if(!isObject(GuiTabPageProfile)) new GuiControlProfile (GuiTabPageProfile : GuiTransparentProfile )
{
   fillColor = "255 255 255";
   opaque = true;
};

if(!isObject(GuiMenuBarProfile)) new GuiControlProfile (GuiMenuBarProfile)
{
   fontType = "Arial";
   fontSize = 15;
   opaque = true;
   fillColor = "239 237 222";
   fillColorHL = "102 153 204";
   borderColor = "138 134 122";
   borderColorHL = "0 51 153";
   border = 5;
   fontColor = "0 0 0";
   fontColorHL = "255 255 255";
   fontColorNA = "128 128 128";
   fixedExtent = true;
   justify = "center";
   canKeyFocus = false;
   mouseOverSelected = true;
   bitmap = "./images/menu";
   hasBitmapArray = true;
};

if(!isObject(GuiConsoleProfile)) new GuiControlProfile (GuiConsoleProfile)
{
   fontType = ($platform $= "macos") ? "Monaco" : "Lucida Console";
   fontSize = ($platform $= "macos") ? 13 : 12;
   fontColor = "0 0 0";
   fontColorHL = "130 130 130";
   fontColorNA = "255 0 0";
   fontColors[6] = "50 50 50";
   fontColors[7] = "50 50 0";  
   fontColors[8] = "0 0 50"; 
   fontColors[9] = "0 50 0";   
};

if(!isObject(GuiConsoleTextEditProfile)) new GuiControlProfile (GuiConsoleTextEditProfile : GuiTextEditProfile)
{
   fontType = ($platform $= "macos") ? "Monaco" : "Lucida Console";
   fontSize = ($platform $= "macos") ? 13 : 12;
};

if (!isObject(GuiTreeViewProfile)) new GuiControlProfile (GuiTreeViewProfile)
{
   fillColorHL = "0 60 150";
   fontSize = 14;
   fontColor = "0 0 0";
   fontColorHL = "64 150 150";
   fontColorNA = "240 240 240";
   fontColorSEL= "250 250 250"; 
   bitmap = "./images/treeView";
   canKeyFocus = true;
   autoSizeHeight = true;
};

//*** DAW:
if(!isObject(GuiText24Profile)) new GuiControlProfile (GuiText24Profile : GuiTextProfile)
{
   fontSize = $font0;
   fontType = "Comic Sans MS";
   justify = "center";
   fontColor = "240 160 45";
   fontColorHL = "100 140 200";

};

if(!isObject(GuiText32Profile)) new GuiControlProfile (GuiText32Profile : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";

};

if(!isObject(GuiText32Left)) new GuiControlProfile (GuiText32Left : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "left";

};

if(!isObject(GuiText32Huxtable)) new GuiControlProfile (GuiText32Huxtable : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "huxtable";
   justify = "center";
   wrap = "1";
};

if(!isObject(GuiText32HuxtableGreen)) new GuiControlProfile (GuiText32HuxtableGreen : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "huxtable";
   justify = "center";
   wrap = "1";
   fontColor = "34 170 37";
};

if(!isObject(GuiText32HuxtableCream)) new GuiControlProfile (GuiText32HuxtableCream : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "huxtable";
   justify = "center";
   wrap = "1";
   fontColor = "247 237 175";
};


if(!isObject(GuiText56Huxtable)) new GuiControlProfile (GuiText56Huxtable : GuiTextProfile)
{
   fontSize = $font2;
   fontType = "huxtable";
   justify = "center";

};

if(!isObject(GuiText56HuxtableCream)) new GuiControlProfile (GuiText56HuxtableCream : GuiTextProfile)
{
   fontSize = $font2;
   fontType = "huxtable";
   justify = "center";
   wrap = "1";
   fontColor = "247 237 175";
};

if(!isObject(GuiText56HuxtableGreen)) new GuiControlProfile (GuiText56HuxtableGreen : GuiTextProfile)
{
   fontSize = $font2;
   fontType = "huxtable";
   justify = "center";
   wrap = "1";
   fontColor = "34 170 37";
};

if(!isObject(GuiText72HuxtableGreen)) new GuiControlProfile (GuiText72HuxtableGreen : GuiTextProfile)
{
   fontSize = $font3;
   fontType = "huxtable";
   justify = "center";
   wrap = "1";
   fontColor = "34 170 37";
};


if(!isObject(GuiText32Comic)) new GuiControlProfile (GuiText32Comic : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
};

if(!isObject(GuiText32ComicBlack)) new GuiControlProfile (GuiText32ComicBlack : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "0 0 0 ";
};

if(!isObject(GuiText24ComicWhite)) new GuiControlProfile (GuiText24ComicWhite : GuiTextProfile)
{
   fontSize = $font0;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "255 255 255 ";
};
if(!isObject(GuiText32ComicWhite)) new GuiControlProfile (GuiText32ComicWhite : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "255 255 255 ";
};

if(!isObject(GuiText32ComicGreen)) new GuiControlProfile (GuiText32ComicGreen : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "34 170 37";
};

if(!isObject(GuiText32ComicCream)) new GuiControlProfile (GuiText32ComicCream : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "247 237 175";
};
if(!isObject(GuiText32LeftComicCream)) new GuiControlProfile (GuiText32LeftComicCream : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "left";
   wrap = "1";
   fontColor = "247 237 175";
};

if(!isObject(GuiText32LeftComicWhite)) new GuiControlProfile (GuiText32LeftComicWhite : GuiTextProfile)
{
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "left";
   wrap = "1";
   fontColor = "255 255 255";
};

if(!isObject(GuiText56Comic)) new GuiControlProfile (GuiText56Comic : GuiTextProfile)
{
   fontSize = $font2;
   fontType = "Comic Sans MS";
   justify = "center";

};

if(!isObject(GuiText56ComicCream)) new GuiControlProfile (GuiText56ComicCream : GuiTextProfile)
{
   fontSize = $font2;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "247 237 175";
};
if(!isObject(GuiText56ComicGreen)) new GuiControlProfile (GuiText56ComicGreen : GuiTextProfile)
{
   fontSize = $font2;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "34 170 37";
};
if(!isObject(GuiText72ComicGreen)) new GuiControlProfile (GuiText72ComicGreen : GuiTextProfile)
{
   fontSize = $font3;
   fontType = "Comic Sans MS";
   justify = "center";
   wrap = "1";
   fontColor = "34 170 37";
};



if(!isObject(GuiMLText24Black)) new GuiControlProfile ("GuiMLText24Black")
{
   //fontSize = $font0*1.1;
   fontType = "Comic Sans MS";
   fontSize = $font0*1.12*0.94;
   //fontType = "Eras Demi ITC";
   autoSizeWidth = true;
   autoSizeHeight = true;  
   border = false;
};








if(!isObject(GuiTextEditMediumProfile)) new GuiControlProfile (GuiTextEditMediumProfile)
{
   opaque = true;
   fillColor = "255 255 255";
   fillColorHL = "128 128 128";
   border = -2;
   bitmap = "./images/textEdit";
   borderColor = "40 40 40 100";
   fontColor = "0 0 0";
   fontColorHL = "255 255 255";
   fontColorNA = "128 128 128";
   textOffset = "4 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
   fontSize = $font0;
   fontType = "Comic Sans MS";
   justify = "center";
   
};
if(!isObject(GuiTextEditLargeProfile)) new GuiControlProfile (GuiTextEditLargeProfile)
{
   opaque = true;
   fillColor = "255 255 255";
   fillColorHL = "128 128 128";
   border = -2;
   bitmap = "./images/textEdit";
   borderColor = "40 40 40 100";
   fontColor = "0 0 0";
   fontColorHL = "255 255 255";
   fontColorNA = "128 128 128";
   textOffset = "4 2";
   autoSizeWidth = false;
   autoSizeHeight = true;
   tab = true;
   canKeyFocus = true;
   fontSize = $font1;
   fontType = "Comic Sans MS";
   justify = "center";
   
};


if(!isObject(GuiRSSFeedMLTextProfile)) new GuiControlProfile ("GuiRSSFeedMLTextProfile")
{
   fontColorLink = "55 55 255";
   fontColorLinkHL = "255 55 55";
};